///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _SS_DEBUG_H
#define _SS_DEBUG_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _EXT_ASSERT_DEBUG

#ifdef _EXT_ASSERT_DEBUG
#define Assert(sExpression, sMsg) \
	if(sExpression)\
	{ \
		char sAssert[2048]; \
		sprintf_s(sAssert, sizeof(sAssert), \
			"A fatal error has occured and the Application must be ended.\r\n" \
			"\tPlease take note of the following error message and conditions.\t\n\r\n" \
			"Application: %s [Version: %s]\r\nFile: \"%s\"\r\n" \
			"App Date/Time: %s (%s)\r\nExpression: \"%s\"\r\nLine: %d\r\n\r\n%s", \
			gsTitleCaption, gsFileVersion, __FILE__, __DATE__, __TIME__, #sExpression, __LINE__, sMsg); \
		MessageBox(NULL, sAssert, "Fatal Application Error!", MB_ICONSTOP|MB_TASKMODAL); \
	}
#else
#define Assert(sExpression, sMsg)
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
